package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class JobStatistics( // [Output-only] Number of child jobs executed.
    numChildJobs: Option[Long] = None, // [Output-only] Quotas which delayed this job's start time.
    quotaDeferments: Option[List[String]] =
      None, // [Output-only] Statistics for data masking. Present only for query and extract jobs.
    dataMaskingStatistics: Option[DataMaskingStatistics] =
      None, // [Output-only] [Deprecated] Use the bytes processed in the query statistics instead.
    totalBytesProcessed: Option[Long] =
      None, // [Output-only] Start time of this job, in milliseconds since the epoch. This field will be present when the job transitions from the PENDING state to either RUNNING or DONE.
    startTime: Option[FiniteDuration] =
      None, // [Output-only] Name of the primary reservation assigned to this job. Note that this could be different than reservations reported in the reservation usage field if parent reservations were used to execute this job.
    reservation_id: Option[String] =
      None, // [Output-only] [Preview] Information of the session if this job is part of one.
    sessionInfo: Option[SessionInfo] = None, // [Output-only] Statistics for a query job.
    query: Option[JobStatistics2] = None, // [Output-only] Statistics for a load job.
    load: Option[JobStatistics3] =
      None, // [Output-only] If this is a child job, the id of the parent.
    parentJobId: Option[String] =
      None, // [Output-only] [Preview] Statistics for row-level security. Present only for query and extract jobs.
    rowLevelSecurityStatistics: Option[RowLevelSecurityStatistics] =
      None, // [Output-only] End time of this job, in milliseconds since the epoch. This field will be present whenever a job is in the DONE state.
    endTime: Option[FiniteDuration] =
      None, // [Output-only] Job resource usage breakdown by reservation.
    reservationUsage: Option[List[JobStatisticsReservationUsage]] =
      None, // [TrustedTester] [Output-only] Job progress (0.0 -> 1.0) for LOAD and EXTRACT jobs.
    completionRatio: Option[Double] = None, // [Output-only] Slot-milliseconds for the job.
    totalSlotMs: Option[FiniteDuration] =
      None, // [Output-only] [Alpha] Information of the multi-statement transaction if this job is part of one.
    transactionInfo: Option[TransactionInfo] = None, // [Output-only] Statistics for a copy job.
    copy: Option[JobStatistics5] = None, // [Output-only] Statistics for a child job of a script.
    scriptStatistics: Option[ScriptStatistics] =
      None, // [Output-only] Statistics for an extract job.
    extract: Option[JobStatistics4] =
      None, // [Output-only] Creation time of this job, in milliseconds since the epoch. This field will be present on all jobs.
    creationTime: Option[FiniteDuration] = None,
)
object JobStatistics {
  implicit val encoder: Encoder[JobStatistics] = Encoder.instance { x =>
    Json.obj(
      "numChildJobs" := x.numChildJobs,
      "quotaDeferments" := x.quotaDeferments,
      "dataMaskingStatistics" := x.dataMaskingStatistics,
      "totalBytesProcessed"
        := x.totalBytesProcessed,
      "startTime" := x.startTime,
      "reservation_id" :=
        x.reservation_id,
      "sessionInfo" := x.sessionInfo,
      "query" := x.query,
      "load" := x.load,
      "parentJobId" := x.parentJobId,
      "rowLevelSecurityStatistics" := x.rowLevelSecurityStatistics,
      "endTime" :=
        x.endTime,
      "reservationUsage" := x.reservationUsage,
      "completionRatio" :=
        x.completionRatio,
      "totalSlotMs" := x.totalSlotMs,
      "transactionInfo" := x.transactionInfo,
      "copy" := x.copy,
      "scriptStatistics" := x.scriptStatistics,
      "extract" := x.extract,
      "creationTime" := x.creationTime,
    )
  }
  implicit val decoder: Decoder[JobStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("numChildJobs")
      v1 <- c.get[Option[List[String]]]("quotaDeferments")
      v2 <- c.get[Option[DataMaskingStatistics]]("dataMaskingStatistics")
      v3 <- c.get[Option[Long]]("totalBytesProcessed")
      v4 <- c.get[Option[FiniteDuration]]("startTime")
      v5 <- c.get[Option[String]]("reservation_id")
      v6 <- c.get[Option[SessionInfo]]("sessionInfo")
      v7 <- c.get[Option[JobStatistics2]]("query")
      v8 <- c.get[Option[JobStatistics3]]("load")
      v9 <- c.get[Option[String]]("parentJobId")
      v10 <- c.get[Option[RowLevelSecurityStatistics]]("rowLevelSecurityStatistics")
      v11 <- c.get[Option[FiniteDuration]]("endTime")
      v12 <- c.get[Option[List[JobStatisticsReservationUsage]]]("reservationUsage")
      v13 <- c.get[Option[Double]]("completionRatio")
      v14 <- c.get[Option[FiniteDuration]]("totalSlotMs")
      v15 <- c.get[Option[TransactionInfo]]("transactionInfo")
      v16 <- c.get[Option[JobStatistics5]]("copy")
      v17 <- c.get[Option[ScriptStatistics]]("scriptStatistics")
      v18 <- c.get[Option[JobStatistics4]]("extract")
      v19 <- c.get[Option[FiniteDuration]]("creationTime")
    } yield JobStatistics(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
    )
  }
}
