package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobReference(
    // [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
    jobId: String,
    // The geographic location of the job. See details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
    location: Option[String] = None,
    // [Required] The ID of the project containing this job.
    projectId: String,
)
object JobReference {
  implicit val encoder: Encoder[JobReference] = Encoder.instance { x =>
    Json.obj(
      "jobId" := x.jobId,
      "location" := x.location,
      "projectId" := x.projectId,
    )
  }
  implicit val decoder: Decoder[JobReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("jobId")
      v1 <- c.get[Option[String]]("location")
      v2 <- c.get[String]("projectId")
    } yield JobReference(v0, v1, v2)
  }
}
