package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobListJob(
    // Running state of the job. When the state is DONE, errorResult can be checked to determine whether the job succeeded or failed.
    state: Option[String] = None,
    // [Output-only] Information about the job, including starting time and ending time of the job.
    statistics: Option[JobStatistics] = None,
    // [Full-projection-only] Email address of the user who ran the job.
    user_email: Option[String] = None,
    // A result object that will be present only if the job has failed.
    errorResult: Option[ErrorProto] = None, // Unique opaque ID of the job.
    id: Option[String] = None,
    // [Full-projection-only] Describes the state of the job.
    status: Option[JobStatus] = None,
    // [Full-projection-only] Specifies the job configuration.
    configuration: Option[JobConfiguration] = None, // The resource type.
    kind: Option[String] = None, // Job reference uniquely identifying the job.
    jobReference: Option[JobReference] = None,
)
object JobListJob {
  implicit val encoder: Encoder[JobListJob] = Encoder.instance { x =>
    Json.obj(
      "state" := x.state,
      "statistics" := x.statistics,
      "user_email" := x.user_email,
      "errorResult" := x.errorResult,
      "id" := x.id,
      "status" := x.status,
      "configuration" := x.configuration,
      "kind" := x.kind,
      "jobReference" := x.jobReference,
    )
  }
  implicit val decoder: Decoder[JobListJob] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("state")
      v1 <- c.get[Option[JobStatistics]]("statistics")
      v2 <- c.get[Option[String]]("user_email")
      v3 <- c.get[Option[ErrorProto]]("errorResult")
      v4 <- c.get[Option[String]]("id")
      v5 <- c.get[Option[JobStatus]]("status")
      v6 <- c.get[Option[JobConfiguration]]("configuration")
      v7 <- c.get[Option[String]]("kind")
      v8 <- c.get[Option[JobReference]]("jobReference")
    } yield JobListJob(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
