package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobList( // A hash of this page of results.
    etag: Option[String] = None, // List of jobs that were requested.
    jobs: Option[List[JobListJob]] = None, // The resource type of the response.
    kind: Option[String] = None, // A token to request the next page of results.
    nextPageToken: Option[String] = None,
)
object JobList {
  implicit val encoder: Encoder[JobList] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "jobs" := x.jobs,
      "kind" := x.kind,
      "nextPageToken" := x.nextPageToken,
    )
  }
  implicit val decoder: Decoder[JobList] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[List[JobListJob]]]("jobs")
      v2 <- c.get[Option[String]]("kind")
      v3 <- c.get[Option[String]]("nextPageToken")
    } yield JobList(v0, v1, v2, v3)
  }
}
