package googleapis.bigquery

import io.circe._

sealed abstract class JobCreationReasonCode(val value: String) extends Product with Serializable
object JobCreationReasonCode {
  // Reason is not specified.
  case object CODE_UNSPECIFIED extends JobCreationReasonCode("CODE_UNSPECIFIED")
  // Job creation was requested.
  case object REQUESTED extends JobCreationReasonCode("REQUESTED")
  // The query request ran beyond a system defined timeout specified by the [timeoutMs field in the QueryRequest](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest). As a result it was considered a long running operation for which a job was created.
  case object LONG_RUNNING extends JobCreationReasonCode("LONG_RUNNING")
  // The results from the query cannot fit in the response.
  case object LARGE_RESULTS extends JobCreationReasonCode("LARGE_RESULTS")
  // BigQuery has determined that the query needs to be executed as a Job.
  case object OTHER extends JobCreationReasonCode("OTHER")
  val values = List(CODE_UNSPECIFIED, REQUESTED, LONG_RUNNING, LARGE_RESULTS, OTHER)
  def fromString(input: String): Either[String, JobCreationReasonCode] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for JobCreationReasonCode")
  implicit val decoder: Decoder[JobCreationReasonCode] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[JobCreationReasonCode] = Encoder[String].contramap(_.value)
}
