package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobCreationReason(
    // Output only. Specifies the high level reason why a Job was created.
    code: Option[JobCreationReasonCode] = None
)
object JobCreationReason {
  implicit val encoder: Encoder[JobCreationReason] = Encoder.instance { x =>
    Json.obj("code" := x.code)
  }
  implicit val decoder: Decoder[JobCreationReason] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[JobCreationReasonCode]]("code")
    } yield JobCreationReason(v0)

  }
}
