package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobConfigurationTableCopy(
    // [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
    writeDisposition: Option[String] = None,
    // [Optional] Supported operation types in table copy job.
    operationType: Option[String] = None, // [Required] The destination table
    destinationTable: TableReference,
    // [Optional] The time when the destination table expires. Expired tables will be deleted and their storage reclaimed.
    destinationExpirationTime: Option[Json] = None,
    // [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
    createDisposition: Option[String] = None, // [Pick one] Source tables to copy.
    sourceTables: Option[List[TableReference]] = None,
    // [Pick one] Source table to copy.
    sourceTable: Option[TableReference] = None,
    // Custom encryption configuration (e.g., Cloud KMS keys).
    destinationEncryptionConfiguration: Option[EncryptionConfiguration] = None,
)
object JobConfigurationTableCopy {
  implicit val encoder: Encoder[
    JobConfigurationTableCopy
  ] = Encoder.instance { x =>
    Json.obj(
      "writeDisposition" := x.writeDisposition,
      "operationType" := x.operationType,
      "destinationTable" := x.destinationTable,
      "destinationExpirationTime" := x.destinationExpirationTime,
      "createDisposition" := x.createDisposition,
      "sourceTables" := x.sourceTables,
      "sourceTable" := x.sourceTable,
      "destinationEncryptionConfiguration" := x.destinationEncryptionConfiguration,
    )
  }
  implicit val decoder: Decoder[
    JobConfigurationTableCopy
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("writeDisposition")
      v1 <- c.get[Option[String]]("operationType")
      v2 <- c.get[TableReference]("destinationTable")
      v3 <- c.get[Option[Json]]("destinationExpirationTime")
      v4 <- c.get[Option[String]]("createDisposition")
      v5 <- c.get[Option[List[TableReference]]]("sourceTables")
      v6 <- c.get[Option[TableReference]]("sourceTable")
      v7 <- c.get[Option[EncryptionConfiguration]]("destinationEncryptionConfiguration")
    } yield JobConfigurationTableCopy(v0, v1, v2, v3, v4, v5, v6, v7)
  }
}
