package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobConfigurationQuery(
    // Describes user-defined function resources used in the query.
    userDefinedFunctionResources: Option[List[UserDefinedFunctionResource]] = None,
    // [Optional] Specifies whether the query should be executed as a continuous query. The default value is false.
    continuous: Option[Boolean] = None,
    // [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH. The default value is INTERACTIVE.
    priority: Option[String] = None,
    // [Optional] Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
    useQueryCache: Option[Boolean] = None,
    // Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be run as if flattenResults is false.
    useLegacySql: Option[Boolean] = None,
    // [Optional] If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
    allowLargeResults: Option[Boolean] = None,
    // [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
    writeDisposition: Option[String] = None,
    // [Optional] Describes the table where the query results should be stored. If not present, a new table will be created to store the results. This property must be set for large results that exceed the maximum response size.
    destinationTable: Option[TableReference] = None,
    // Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
    parameterMode: Option[String] = None,
    // [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
    maximumBillingTier: Option[Int] = None,
    // [Required] SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
    query: String,
    // If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-session mode.
    createSession: Option[Boolean] = None,
    // [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
    maximumBytesBilled: Option[Long] = None,
    // Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
    timePartitioning: Option[TimePartitioning] = None, // Connection properties.
    connectionProperties: Option[List[ConnectionProperty]] = None,
    // [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
    createDisposition: Option[String] = None,
    // [Deprecated] This property is deprecated.
    preserveNulls: Option[Boolean] = None,
    // [Optional] If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
    flattenResults: Option[Boolean] = None,
    // Query parameters for standard SQL queries.
    queryParameters: Option[List[QueryParameter]] = None,
    // [Optional] If querying an external data source outside of BigQuery, describes the data format, location and other properties of the data source. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
    tableDefinitions: Option[Map[String, ExternalDataConfiguration]] = None,
    // [Optional] Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
    defaultDataset: Option[DatasetReference] = None,
    // Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
    schemaUpdateOptions: Option[List[String]] = None,
    // Custom encryption configuration (e.g., Cloud KMS keys).
    destinationEncryptionConfiguration: Option[EncryptionConfiguration] = None,
    // [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
    rangePartitioning: Option[RangePartitioning] = None,
    // [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
    clustering: Option[Clustering] = None,
)
object JobConfigurationQuery {
  implicit val encoder: Encoder[JobConfigurationQuery] = Encoder.instance { x =>
    Json.obj(
      "userDefinedFunctionResources" := x.userDefinedFunctionResources,
      "continuous" := x.continuous,
      "priority" := x.priority,
      "useQueryCache" :=
        x.useQueryCache,
      "useLegacySql" := x.useLegacySql,
      "allowLargeResults" :=
        x.allowLargeResults,
      "writeDisposition" := x.writeDisposition,
      "destinationTable" := x.destinationTable,
      "parameterMode" := x.parameterMode,
      "maximumBillingTier" := x.maximumBillingTier,
      "query" := x.query,
      "createSession" := x.createSession,
      "maximumBytesBilled" := x.maximumBytesBilled,
      "timePartitioning" := x.timePartitioning,
      "connectionProperties" := x.connectionProperties,
      "createDisposition" := x.createDisposition,
      "preserveNulls" := x.preserveNulls,
      "flattenResults"
        := x.flattenResults,
      "queryParameters" := x.queryParameters,
      "tableDefinitions" := x.tableDefinitions,
      "defaultDataset" := x.defaultDataset,
      "schemaUpdateOptions" := x.schemaUpdateOptions,
      "destinationEncryptionConfiguration" := x.destinationEncryptionConfiguration,
      "rangePartitioning" := x.rangePartitioning,
      "clustering" := x.clustering,
    )
  }
  implicit val decoder: Decoder[JobConfigurationQuery] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[UserDefinedFunctionResource]]]("userDefinedFunctionResources")
      v1 <- c.get[Option[Boolean]]("continuous")
      v2 <- c.get[Option[String]]("priority")
      v3 <- c.get[Option[Boolean]]("useQueryCache")
      v4 <- c.get[Option[Boolean]]("useLegacySql")
      v5 <- c.get[Option[Boolean]]("allowLargeResults")
      v6 <- c.get[Option[String]]("writeDisposition")
      v7 <- c.get[Option[TableReference]]("destinationTable")
      v8 <- c.get[Option[String]]("parameterMode")
      v9 <- c.get[Option[Int]]("maximumBillingTier")
      v10 <- c.get[String]("query")
      v11 <- c.get[Option[Boolean]]("createSession")
      v12 <- c.get[Option[Long]]("maximumBytesBilled")
      v13 <- c.get[Option[TimePartitioning]]("timePartitioning")
      v14 <- c.get[Option[List[ConnectionProperty]]]("connectionProperties")
      v15 <- c.get[Option[String]]("createDisposition")
      v16 <- c.get[Option[Boolean]]("preserveNulls")
      v17 <- c.get[Option[Boolean]]("flattenResults")
      v18 <- c.get[Option[List[QueryParameter]]]("queryParameters")
      v19 <- c.get[Option[Map[String, ExternalDataConfiguration]]]("tableDefinitions")
      v20 <- c.get[Option[DatasetReference]]("defaultDataset")
      v21 <- c.get[Option[List[String]]]("schemaUpdateOptions")
      v22 <- c.get[Option[EncryptionConfiguration]]("destinationEncryptionConfiguration")
      v23 <- c.get[Option[RangePartitioning]]("rangePartitioning")
      v24 <- c.get[Option[Clustering]]("clustering")
    } yield JobConfigurationQuery(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
      v23,
      v24,
    )

  }
}
