package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobConfigurationLoad(
    // [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
    useAvroLogicalTypes: Option[Boolean] = None,
    // [Optional] If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON. For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON: set to GEOJSON.
    jsonExtension: Option[String] = None,
    // [Beta] [Optional] Properties with which to create the destination table if it is new.
    destinationTableProperties: Option[DestinationTableProperties] = None,
    // [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
    writeDisposition: Option[String] = None,
    // [Optional] Options to configure parquet support.
    parquetOptions: Option[ParquetOptions] = None,
    // [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\x00' to '\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
    preserveAsciiControlCharacters: Option[Boolean] = None,
    // [Required] The destination table to load the data into.
    destinationTable: TableReference,
    // [Optional] The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
    sourceFormat: Option[String] = None,
    // [Optional] The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
    fieldDelimiter: Option[String] = None,
    // User provided referencing file with the expected reader schema, Available for the format: AVRO, PARQUET, ORC.
    referenceFileSchemaUri: Option[String] = None,
    // [Deprecated] The inline schema. For CSV schemas, specify as "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER, baz:FLOAT".
    schemaInline: Option[String] = None,
    // [Optional] The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.
    skipLeadingRows: Option[Int] = None,
    // [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
    encoding: Option[String] = None,
    // [Optional] The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV and JSON. The default value is 0, which requires that all records are valid.
    maxBadRecords: Option[Int] = None,
    // [Optional] Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
    allowJaggedRows: Option[Boolean] = None,
    // [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
    ignoreUnknownValues: Option[Boolean] = None,
    // If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs the load job in non-session mode.
    createSession: Option[Boolean] = None,
    // [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
    quote: Option[String] = None,
    // [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
    decimalTargetTypes: Option[List[String]] = None,
    // [Optional] The schema for the destination table. The schema can be omitted if the destination table already exists, or if you're loading data from Google Cloud Datastore.
    schema: Option[TableSchema] = None,
    // Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
    timePartitioning: Option[TimePartitioning] = None,
    // [Optional] Options to configure hive partitioning support.
    hivePartitioningOptions: Option[HivePartitioningOptions] = None,
    // Connection properties.
    connectionProperties: Option[List[ConnectionProperty]] = None,
    // [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
    createDisposition: Option[String] = None,
    // Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
    allowQuotedNewlines: Option[Boolean] = None,
    // [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
    sourceUris: List[String],
    // If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
    projectionFields: Option[List[String]] = None,
    // [Optional] Specifies how source URIs are interpreted for constructing the file set to load. By default source URIs are expanded against the underlying storage. Other options include specifying manifest files. Only applicable to object storage systems.
    fileSetSpecType: Option[String] = None,
    // [Deprecated] The format of the schemaInline property.
    schemaInlineFormat: Option[String] = None,
    // [Optional] Specifies a string that represents a null value in a CSV file. For example, if you specify "\N", BigQuery interprets "\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
    nullMarker: Option[String] = None,
    // Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
    schemaUpdateOptions: Option[List[String]] = None,
    // Custom encryption configuration (e.g., Cloud KMS keys).
    destinationEncryptionConfiguration: Option[EncryptionConfiguration] = None,
    // [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
    rangePartitioning: Option[RangePartitioning] = None,
    // [Optional] Indicates if we should automatically infer the options and schema for CSV and JSON sources.
    autodetect: Option[Boolean] = None,
    // [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
    clustering: Option[Clustering] = None,
)
object JobConfigurationLoad {
  implicit val encoder: Encoder[JobConfigurationLoad] = Encoder.instance { x =>
    Json.obj(
      "useAvroLogicalTypes" := x.useAvroLogicalTypes,
      "jsonExtension" := x.jsonExtension,
      "destinationTableProperties" := x.destinationTableProperties,
      "writeDisposition" := x.writeDisposition,
      "parquetOptions" := x.parquetOptions,
      "preserveAsciiControlCharacters" :=
        x.preserveAsciiControlCharacters,
      "destinationTable" := x.destinationTable,
      "sourceFormat" := x.sourceFormat,
      "fieldDelimiter" := x.fieldDelimiter,
      "referenceFileSchemaUri" := x.referenceFileSchemaUri,
      "schemaInline" := x.schemaInline,
      "skipLeadingRows" := x.skipLeadingRows,
      "encoding" := x.encoding,
      "maxBadRecords" := x.maxBadRecords,
      "allowJaggedRows" := x.allowJaggedRows,
      "ignoreUnknownValues" := x.ignoreUnknownValues,
      "createSession" := x.createSession,
      "quote" := x.quote,
      "decimalTargetTypes" := x.decimalTargetTypes,
      "schema" := x.schema,
      "timePartitioning" := x.timePartitioning,
      "hivePartitioningOptions" := x.hivePartitioningOptions,
      "connectionProperties" := x.connectionProperties,
      "createDisposition" := x.createDisposition,
      "allowQuotedNewlines" := x.allowQuotedNewlines,
      "sourceUris" := x.sourceUris,
      "projectionFields" := x.projectionFields,
      "fileSetSpecType" := x.fileSetSpecType,
      "schemaInlineFormat" := x.schemaInlineFormat,
      "nullMarker" := x.nullMarker,
      "schemaUpdateOptions" := x.schemaUpdateOptions,
      "destinationEncryptionConfiguration" := x.destinationEncryptionConfiguration,
      "rangePartitioning" := x.rangePartitioning,
      "autodetect" := x.autodetect,
      "clustering" := x.clustering,
    )
  }
  implicit val decoder: Decoder[JobConfigurationLoad] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("useAvroLogicalTypes")
      v1 <- c.get[Option[String]]("jsonExtension")
      v2 <- c.get[Option[DestinationTableProperties]]("destinationTableProperties")
      v3 <- c.get[Option[String]]("writeDisposition")
      v4 <- c.get[Option[ParquetOptions]]("parquetOptions")
      v5 <- c.get[Option[Boolean]]("preserveAsciiControlCharacters")
      v6 <- c.get[TableReference]("destinationTable")
      v7 <- c.get[Option[String]]("sourceFormat")
      v8 <- c.get[Option[String]]("fieldDelimiter")
      v9 <- c.get[Option[String]]("referenceFileSchemaUri")
      v10 <- c.get[Option[String]]("schemaInline")
      v11 <- c.get[Option[Int]]("skipLeadingRows")
      v12 <- c.get[Option[String]]("encoding")
      v13 <- c.get[Option[Int]]("maxBadRecords")
      v14 <- c.get[Option[Boolean]]("allowJaggedRows")
      v15 <- c.get[Option[Boolean]]("ignoreUnknownValues")
      v16 <- c.get[Option[Boolean]]("createSession")
      v17 <- c.get[Option[String]]("quote")
      v18 <- c.get[Option[List[String]]]("decimalTargetTypes")
      v19 <- c.get[Option[TableSchema]]("schema")
      v20 <- c.get[Option[TimePartitioning]]("timePartitioning")
      v21 <- c.get[Option[HivePartitioningOptions]]("hivePartitioningOptions")
      v22 <- c.get[Option[List[ConnectionProperty]]]("connectionProperties")
      v23 <- c.get[Option[String]]("createDisposition")
      v24 <- c.get[Option[Boolean]]("allowQuotedNewlines")
      v25 <- c.get[List[String]]("sourceUris")
      v26 <- c.get[Option[List[String]]]("projectionFields")
      v27 <- c.get[Option[String]]("fileSetSpecType")
      v28 <- c.get[Option[String]]("schemaInlineFormat")
      v29 <- c.get[Option[String]]("nullMarker")
      v30 <- c.get[Option[List[String]]]("schemaUpdateOptions")
      v31 <- c.get[Option[EncryptionConfiguration]]("destinationEncryptionConfiguration")
      v32 <- c.get[Option[RangePartitioning]]("rangePartitioning")
      v33 <- c.get[Option[Boolean]]("autodetect")
      v34 <- c.get[Option[Clustering]]("clustering")
    } yield JobConfigurationLoad(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
      v23,
      v24,
      v25,
      v26,
      v27,
      v28,
      v29,
      v30,
      v31,
      v32,
      v33,
      v34,
    )

  }
}
