package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobConfigurationExtract(
    // [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
    destinationUris: Option[List[String]] = None,
    // [Optional] If destinationFormat is set to "AVRO", this flag indicates whether to enable extracting applicable column types (such as TIMESTAMP) to their corresponding AVRO logical types (timestamp-micros), instead of only using their raw types (avro-long). Not applicable when extracting models.
    useAvroLogicalTypes: Option[Boolean] = None,
    // A reference to the model being exported.
    sourceModel: Option[ModelReference] = None,
    // [Optional] Whether to print out a header row in the results. Default is true. Not applicable when extracting models.
    printHeader: Option[Boolean] = None,
    // [Optional] The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not applicable when extracting models.
    compression: Option[String] = None,
    // [Optional] Delimiter to use between fields in the exported data. Default is ','. Not applicable when extracting models.
    fieldDelimiter: Option[String] = None,
    // [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The fully-qualified Google Cloud Storage URI where the extracted table should be written.
    destinationUri: Option[String] = None,
    // [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
    destinationFormat: Option[String] = None,
    // A reference to the table being exported.
    sourceTable: Option[TableReference] = None,
)
object JobConfigurationExtract {
  implicit val encoder: Encoder[
    JobConfigurationExtract
  ] = Encoder.instance { x =>
    Json.obj(
      "destinationUris" := x.destinationUris,
      "useAvroLogicalTypes" := x.useAvroLogicalTypes,
      "sourceModel" := x.sourceModel,
      "printHeader" := x.printHeader,
      "compression" := x.compression,
      "fieldDelimiter" := x.fieldDelimiter,
      "destinationUri" := x.destinationUri,
      "destinationFormat"
        := x.destinationFormat,
      "sourceTable" := x.sourceTable,
    )
  }
  implicit val decoder: Decoder[
    JobConfigurationExtract
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("destinationUris")
      v1 <- c.get[Option[Boolean]]("useAvroLogicalTypes")
      v2 <- c.get[Option[ModelReference]]("sourceModel")
      v3 <- c.get[Option[Boolean]]("printHeader")
      v4 <- c.get[Option[String]]("compression")
      v5 <- c.get[Option[String]]("fieldDelimiter")
      v6 <- c.get[Option[String]]("destinationUri")
      v7 <- c.get[Option[String]]("destinationFormat")
      v8 <- c.get[Option[TableReference]]("sourceTable")
    } yield JobConfigurationExtract(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
