package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class JobConfiguration(
    // [Optional] Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
    jobTimeoutMs: Option[FiniteDuration] = None,
    // [Pick one] Configures a query job.
    query: Option[JobConfigurationQuery] = None,
    // [Pick one] Configures a load job.
    load: Option[JobConfigurationLoad] = None,
    // [Output-only] The type of the job. Can be QUERY, LOAD, EXTRACT, COPY or UNKNOWN.
    jobType: Option[String] = None,
    // The labels associated with this job. You can use these to organize and group your jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
    labels: Option[Map[String, String]] = None, // [Pick one] Copies a table.
    copy: Option[JobConfigurationTableCopy] = None,
    // [Optional] If set, don't actually run this job. A valid query will return a mostly empty response with some processing statistics, while an invalid query will return the same error it would if it wasn't a dry run. Behavior of non-query jobs is undefined.
    dryRun: Option[Boolean] = None, // [Pick one] Configures an extract job.
    extract: Option[JobConfigurationExtract] = None,
)
object JobConfiguration {
  implicit val encoder: Encoder[JobConfiguration] = Encoder.instance { x =>
    Json.obj(
      "jobTimeoutMs" := x.jobTimeoutMs,
      "query" := x.query,
      "load" := x.load,
      "jobType" := x.jobType,
      "labels" := x.labels,
      "copy" := x.copy,
      "dryRun"
        := x.dryRun,
      "extract" := x.extract,
    )
  }
  implicit val decoder: Decoder[JobConfiguration] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[FiniteDuration]]("jobTimeoutMs")
      v1 <- c.get[Option[JobConfigurationQuery]]("query")
      v2 <- c.get[Option[JobConfigurationLoad]]("load")
      v3 <- c.get[Option[String]]("jobType")
      v4 <- c.get[Option[Map[String, String]]]("labels")
      v5 <- c.get[Option[JobConfigurationTableCopy]]("copy")
      v6 <- c.get[Option[Boolean]]("dryRun")
      v7 <- c.get[Option[JobConfigurationExtract]]("extract")
    } yield JobConfiguration(v0, v1, v2, v3, v4, v5, v6, v7)
  }
}
