package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobCancelResponse( // The final state of the job.
    job: Option[Job] = None, // The resource type of the response.
    kind: Option[String] = None,
)
object JobCancelResponse {
  implicit val encoder: Encoder[JobCancelResponse] = Encoder.instance { x =>
    Json.obj("job" := x.job, "kind" := x.kind)
  }
  implicit val decoder: Decoder[JobCancelResponse] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Job]]("job")
      v1 <- c.get[Option[String]]("kind")
    } yield JobCancelResponse(v0, v1)

  }
}
