package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Job( // [Output-only] A hash of this resource.
    etag: Option[String] =
      None, // [Output-only] Information about the job, including starting time and ending time of the job.
    statistics: Option[JobStatistics] =
      None, // [Output-only] A URL that can be used to access this resource again.
    selfLink: Option[String] =
      None, // [Output-only] If set, it provides the reason why a Job was created. If not set, it should be treated as the default: REQUESTED. This feature is not yet available. Jobs will always be created.
    jobCreationReason: Option[Json] =
      None, // [Output-only] Email address of the user who ran the job.
    user_email: Option[String] = None, // [Output-only] Opaque ID field of the job
    id: Option[String] =
      None, // [Output-only] The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
    status: Option[JobStatus] = None, // [Required] Describes the job configuration.
    configuration: JobConfiguration, // [Output-only] The type of the resource.
    kind: Option[String] =
      None, // [Optional] Reference describing the unique-per-user name of the job.
    jobReference: Option[JobReference] = None,
)
object Job {
  implicit val encoder: Encoder[Job] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "statistics" := x.statistics,
      "selfLink" := x.selfLink,
      "jobCreationReason" := x.jobCreationReason,
      "user_email" := x.user_email,
      "id" := x.id,
      "status" := x.status,
      "configuration" := x.configuration,
      "kind" := x.kind,
      "jobReference" := x.jobReference,
    )
  }
  implicit val decoder: Decoder[Job] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[JobStatistics]]("statistics")
      v2 <- c.get[Option[String]]("selfLink")
      v3 <- c.get[Option[Json]]("jobCreationReason")
      v4 <- c.get[Option[String]]("user_email")
      v5 <- c.get[Option[String]]("id")
      v6 <- c.get[Option[JobStatus]]("status")
      v7 <- c.get[JobConfiguration]("configuration")
      v8 <- c.get[Option[String]]("kind")
      v9 <- c.get[Option[JobReference]]("jobReference")
    } yield Job(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9)
  }
}
