package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class IterationResult(
    // Loss computed on the training data at the end of iteration.
    trainingLoss: Option[Double] = None, // Learn rate used for this iteration.
    learnRate: Option[Double] = None,
    // Time taken to run the iteration in milliseconds.
    durationMs: Option[FiniteDuration] = None, // Index of the iteration, 0 based.
    index: Option[Int] = None,
    // Loss computed on the eval data at the end of iteration.
    evalLoss: Option[Double] = None,
)
object IterationResult {
  implicit val encoder: Encoder[IterationResult] = Encoder.instance { x =>
    Json.obj(
      "trainingLoss" := x.trainingLoss,
      "learnRate" := x.learnRate,
      "durationMs"
        := x.durationMs,
      "index" := x.index,
      "evalLoss" := x.evalLoss,
    )
  }
  implicit val decoder: Decoder[IterationResult] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("trainingLoss")
      v1 <- c.get[Option[Double]]("learnRate")
      v2 <- c.get[Option[FiniteDuration]]("durationMs")
      v3 <- c.get[Option[Int]]("index")
      v4 <- c.get[Option[Double]]("evalLoss")
    } yield IterationResult(v0, v1, v2, v3, v4)
  }
}
