package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IntRange( // Max value of the int parameter.
    max: Option[Long] = None, // Min value of the int parameter.
    min: Option[Long] = None,
)
object IntRange {
  implicit val encoder: Encoder[IntRange] = Encoder.instance { x =>
    Json.obj("max" := x.max, "min" := x.min)
  }
  implicit val decoder: Decoder[IntRange] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("max")
      v1 <- c.get[Option[Long]]("min")
    } yield IntRange(v0, v1)
  }
}
