package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IntHparamSearchSpace( // Candidates of the int hyperparameter.
    candidates: Option[IntCandidates] = None, // Range of the int hyperparameter.
    range: Option[IntRange] = None,
)
object IntHparamSearchSpace {
  implicit val encoder: Encoder[IntHparamSearchSpace] = Encoder.instance { x =>
    Json.obj("candidates" := x.candidates, "range" := x.range)
  }
  implicit val decoder: Decoder[IntHparamSearchSpace] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[IntCandidates]]("candidates")
      v1 <- c.get[Option[IntRange]]("range")
    } yield IntHparamSearchSpace(v0, v1)

  }
}
