package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IntCandidates(
    // Candidates for the int parameter in increasing order.
    candidates: Option[List[Long]] = None
)
object IntCandidates {
  implicit val encoder: Encoder[IntCandidates] = Encoder.instance { x =>
    Json.obj("candidates" := x.candidates)
  }
  implicit val decoder: Decoder[IntCandidates] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Long]]]("candidates")
    } yield IntCandidates(v0)
  }
}
