package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IntArrayHparamSearchSpace(
    // Candidates for the int array parameter.
    candidates: Option[List[IntArray]] = None
)
object IntArrayHparamSearchSpace {
  implicit val encoder: Encoder[
    IntArrayHparamSearchSpace
  ] = Encoder.instance(x => Json.obj("candidates" := x.candidates))
  implicit val decoder: Decoder[
    IntArrayHparamSearchSpace
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[IntArray]]]("candidates")
    } yield IntArrayHparamSearchSpace(v0)
  }
}
