package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IntArray( // Elements in the int array.
    elements: Option[List[Long]] = None
)
object IntArray {
  implicit val encoder: Encoder[IntArray] = Encoder.instance { x =>
    Json.obj("elements" := x.elements)
  }
  implicit val decoder: Decoder[IntArray] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Long]]]("elements")
    } yield IntArray(v0)
  }
}
