package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class IndexUnusedReason(
    // [Output-only] Specifies the base table involved in the reason that no search index was used.
    baseTable: Option[TableReference] = None,
    // [Output-only] Specifies the high-level reason for the scenario when no search index was used.
    code: Option[String] = None,
    // [Output-only] Specifies the name of the unused search index, if available.
    indexName: Option[String] = None,
    // [Output-only] Free form human-readable reason for the scenario when no search index was used.
    message: Option[String] = None,
)
object IndexUnusedReason {
  implicit val encoder: Encoder[IndexUnusedReason] = Encoder.instance { x =>
    Json.obj(
      "baseTable" := x.baseTable,
      "code" := x.code,
      "indexName" := x.indexName,
      "message" := x.message,
    )
  }
  implicit val decoder: Decoder[IndexUnusedReason] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[TableReference]]("baseTable")
      v1 <- c.get[Option[String]]("code")
      v2 <- c.get[Option[String]]("indexName")
      v3 <- c.get[Option[String]]("message")
    } yield IndexUnusedReason(v0, v1, v2, v3)

  }
}
