package googleapis.bigquery

import io.circe._

sealed abstract class HparamTuningTrialStatus(val value: String) extends Product with Serializable
object HparamTuningTrialStatus {
  // Default value.
  case object TRIAL_STATUS_UNSPECIFIED extends HparamTuningTrialStatus("TRIAL_STATUS_UNSPECIFIED")
  // Scheduled but not started.
  case object NOT_STARTED extends HparamTuningTrialStatus("NOT_STARTED")
  // Running state.
  case object RUNNING extends HparamTuningTrialStatus("RUNNING")
  // The trial succeeded.
  case object SUCCEEDED extends HparamTuningTrialStatus("SUCCEEDED")
  // The trial failed.
  case object FAILED extends HparamTuningTrialStatus("FAILED")
  // The trial is infeasible due to the invalid params.
  case object INFEASIBLE extends HparamTuningTrialStatus("INFEASIBLE")
  // Trial stopped early because it's not promising.
  case object STOPPED_EARLY extends HparamTuningTrialStatus("STOPPED_EARLY")
  val values = List(
    TRIAL_STATUS_UNSPECIFIED,
    NOT_STARTED,
    RUNNING,
    SUCCEEDED,
    FAILED,
    INFEASIBLE,
    STOPPED_EARLY,
  )
  def fromString(input: String): Either[String, HparamTuningTrialStatus] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for HparamTuningTrialStatus")
  implicit val decoder: Decoder[HparamTuningTrialStatus] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[HparamTuningTrialStatus] = Encoder[String].contramap(_.value)
}
