package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class HparamTuningTrial(
    // Loss computed on the training data at the end of trial.
    trainingLoss: Option[Double] = None,
    // The hyperprameters selected for this trial.
    hparams: Option[TrainingOptions] = None,
    // Error message for FAILED and INFEASIBLE trial.
    errorMessage: Option[String] = None, // Ending time of the trial.
    endTimeMs: Option[Long] = None, // Starting time of the trial.
    startTimeMs: Option[Long] = None, // 1-based index of the trial.
    trialId: Option[Long] = None,
    // Hyperparameter tuning evaluation metrics of this trial calculated on the eval data. Unlike evaluation_metrics, only the fields corresponding to the hparam_tuning_objectives are set.
    hparamTuningEvaluationMetrics: Option[EvaluationMetrics] = None,
    // The status of the trial.
    status: Option[HparamTuningTrialStatus] = None,
    // Evaluation metrics of this trial calculated on the test data. Empty in Job API.
    evaluationMetrics: Option[EvaluationMetrics] = None,
    // Loss computed on the eval data at the end of trial.
    evalLoss: Option[Double] = None,
)
object HparamTuningTrial {
  implicit val encoder: Encoder[HparamTuningTrial] = Encoder.instance { x =>
    Json.obj(
      "trainingLoss" := x.trainingLoss,
      "hparams" := x.hparams,
      "errorMessage"
        := x.errorMessage,
      "endTimeMs" := x.endTimeMs,
      "startTimeMs" := x.startTimeMs,
      "trialId" := x.trialId,
      "hparamTuningEvaluationMetrics" := x.hparamTuningEvaluationMetrics,
      "status" := x.status,
      "evaluationMetrics"
        := x.evaluationMetrics,
      "evalLoss" := x.evalLoss,
    )
  }
  implicit val decoder: Decoder[HparamTuningTrial] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("trainingLoss")
      v1 <- c.get[Option[TrainingOptions]]("hparams")
      v2 <- c.get[Option[String]]("errorMessage")
      v3 <- c.get[Option[Long]]("endTimeMs")
      v4 <- c.get[Option[Long]]("startTimeMs")
      v5 <- c.get[Option[Long]]("trialId")
      v6 <- c.get[Option[EvaluationMetrics]]("hparamTuningEvaluationMetrics")
      v7 <- c.get[Option[HparamTuningTrialStatus]]("status")
      v8 <- c.get[Option[EvaluationMetrics]]("evaluationMetrics")
      v9 <- c.get[Option[Double]]("evalLoss")
    } yield HparamTuningTrial(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9)

  }
}
