package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class HparamSearchSpaces( // Optimizer of TF models.
    optimizer: Option[StringHparamSearchSpace] = None, // Mini batch sample size.
    batchSize: Option[IntHparamSearchSpace] = None, // L1 regularization coefficient.
    l1Reg: Option[DoubleHparamSearchSpace] =
      None, // Dropout probability for dnn model training and boosted tree models using dart booster.
    dropout: Option[DoubleHparamSearchSpace] =
      None, // Minimum sum of instance weight needed in a child for boosted tree models.
    minTreeChildWeight: Option[IntHparamSearchSpace] =
      None, // Subsample ratio of columns for each level for boosted tree models.
    colsampleBylevel: Option[DoubleHparamSearchSpace] =
      None, // Subsample the training data to grow tree to prevent overfitting for boosted tree models.
    subsample: Option[DoubleHparamSearchSpace] =
      None, // Dart normalization type for boosted tree models.
    dartNormalizeType: Option[StringHparamSearchSpace] = None, // Number of clusters for k-means.
    numClusters: Option[IntHparamSearchSpace] =
      None, // Activation functions of neural network models.
    activationFn: Option[StringHparamSearchSpace] = None, // Booster type for boosted tree models.
    boosterType: Option[StringHparamSearchSpace] =
      None, // Subsample ratio of columns for each node(split) for boosted tree models.
    colsampleBynode: Option[DoubleHparamSearchSpace] =
      None, // Hyperparameter for matrix factoration when implicit feedback type is specified.
    walsAlpha: Option[DoubleHparamSearchSpace] =
      None, // Minimum split loss for boosted tree models.
    minSplitLoss: Option[DoubleHparamSearchSpace] = None, // Learning rate of training jobs.
    learnRate: Option[DoubleHparamSearchSpace] =
      None, // Number of parallel trees for boosted tree models.
    numParallelTree: Option[IntHparamSearchSpace] = None, // Number of latent factors to train on.
    numFactors: Option[IntHparamSearchSpace] =
      None, // Subsample ratio of columns when constructing each tree for boosted tree models.
    colsampleBytree: Option[DoubleHparamSearchSpace] =
      None, // Tree construction algorithm for boosted tree models.
    treeMethod: Option[StringHparamSearchSpace] = None, // L2 regularization coefficient.
    l2Reg: Option[DoubleHparamSearchSpace] = None, // Hidden units for neural network models.
    hiddenUnits: Option[IntArrayHparamSearchSpace] =
      None, // Maximum depth of a tree for boosted tree models.
    maxTreeDepth: Option[IntHparamSearchSpace] = None,
)
object HparamSearchSpaces {
  implicit val encoder: Encoder[HparamSearchSpaces] = Encoder.instance { x =>
    Json.obj(
      "optimizer" := x.optimizer,
      "batchSize" := x.batchSize,
      "l1Reg" := x.l1Reg,
      "dropout" := x.dropout,
      "minTreeChildWeight" := x.minTreeChildWeight,
      "colsampleBylevel" := x.colsampleBylevel,
      "subsample"
        := x.subsample,
      "dartNormalizeType" := x.dartNormalizeType,
      "numClusters"
        := x.numClusters,
      "activationFn" := x.activationFn,
      "boosterType" := x.boosterType,
      "colsampleBynode" := x.colsampleBynode,
      "walsAlpha" := x.walsAlpha,
      "minSplitLoss" := x.minSplitLoss,
      "learnRate" := x.learnRate,
      "numParallelTree" := x.numParallelTree,
      "numFactors" := x.numFactors,
      "colsampleBytree" := x.colsampleBytree,
      "treeMethod" := x.treeMethod,
      "l2Reg" := x.l2Reg,
      "hiddenUnits" := x.hiddenUnits,
      "maxTreeDepth" := x.maxTreeDepth,
    )
  }
  implicit val decoder: Decoder[HparamSearchSpaces] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[StringHparamSearchSpace]]("optimizer")
      v1 <- c.get[Option[IntHparamSearchSpace]]("batchSize")
      v2 <- c.get[Option[DoubleHparamSearchSpace]]("l1Reg")
      v3 <- c.get[Option[DoubleHparamSearchSpace]]("dropout")
      v4 <- c.get[Option[IntHparamSearchSpace]]("minTreeChildWeight")
      v5 <- c.get[Option[DoubleHparamSearchSpace]]("colsampleBylevel")
      v6 <- c.get[Option[DoubleHparamSearchSpace]]("subsample")
      v7 <- c.get[Option[StringHparamSearchSpace]]("dartNormalizeType")
      v8 <- c.get[Option[IntHparamSearchSpace]]("numClusters")
      v9 <- c.get[Option[StringHparamSearchSpace]]("activationFn")
      v10 <- c.get[Option[StringHparamSearchSpace]]("boosterType")
      v11 <- c.get[Option[DoubleHparamSearchSpace]]("colsampleBynode")
      v12 <- c.get[Option[DoubleHparamSearchSpace]]("walsAlpha")
      v13 <- c.get[Option[DoubleHparamSearchSpace]]("minSplitLoss")
      v14 <- c.get[Option[DoubleHparamSearchSpace]]("learnRate")
      v15 <- c.get[Option[IntHparamSearchSpace]]("numParallelTree")
      v16 <- c.get[Option[IntHparamSearchSpace]]("numFactors")
      v17 <- c.get[Option[DoubleHparamSearchSpace]]("colsampleBytree")
      v18 <- c.get[Option[StringHparamSearchSpace]]("treeMethod")
      v19 <- c.get[Option[DoubleHparamSearchSpace]]("l2Reg")
      v20 <- c.get[Option[IntArrayHparamSearchSpace]]("hiddenUnits")
      v21 <- c.get[Option[IntHparamSearchSpace]]("maxTreeDepth")
    } yield HparamSearchSpaces(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
    )

  }
}
