package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class HivePartitioningOptions(
    // [Output-only] For permanent external tables, this field is populated with the hive partition keys in the order they were inferred. The types of the partition keys can be deduced by checking the table schema (which will include the partition keys). Not every API will populate this field in the output. For example, Tables.Get will populate it, but Tables.List will not contain this field.
    fields: Option[List[String]] = None,
    // [Optional] When set, what mode of hive partitioning to use when reading data. The following modes are supported. (1) AUTO: automatically infer partition key name(s) and type(s). (2) STRINGS: automatically infer partition key name(s). All types are interpreted as strings. (3) CUSTOM: partition key schema is encoded in the source URI prefix. Not all storage formats support hive partitioning. Requesting hive partitioning on an unsupported format will lead to an error. Currently supported types include: AVRO, CSV, JSON, ORC and Parquet.
    mode: Option[String] = None,
    // [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified. Note that this field should only be true when creating a permanent external table or querying a temporary external table. Hive-partitioned loads with requirePartitionFilter explicitly set to true will fail.
    requirePartitionFilter: Option[Boolean] = None,
    // [Optional] When hive partition detection is requested, a common prefix for all source uris should be supplied. The prefix must end immediately before the partition key encoding begins. For example, consider files following this data layout. gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When hive partitioning is requested with either AUTO or STRINGS detection, the common prefix can be either of gs://bucket/path_to_table or gs://bucket/path_to_table/ (trailing slash does not matter).
    sourceUriPrefix: Option[String] = None,
)
object HivePartitioningOptions {
  implicit val encoder: Encoder[
    HivePartitioningOptions
  ] = Encoder.instance { x =>
    Json.obj(
      "fields" := x.fields,
      "mode" := x.mode,
      "requirePartitionFilter" := x.requirePartitionFilter,
      "sourceUriPrefix" := x.sourceUriPrefix,
    )
  }
  implicit val decoder: Decoder[
    HivePartitioningOptions
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("fields")
      v1 <- c.get[Option[String]]("mode")
      v2 <- c.get[Option[Boolean]]("requirePartitionFilter")
      v3 <- c.get[Option[String]]("sourceUriPrefix")
    } yield HivePartitioningOptions(v0, v1, v2, v3)
  }
}
