package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class GoogleSheetsOptions(
    // [Optional] Range of a sheet to query from. Only used when non-empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For example: sheet1!A1:B20
    range: Option[String] = None,
    // [Optional] The number of rows at the top of a sheet that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows that should be skipped. When autodetect is on, behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
    skipLeadingRows: Option[Long] = None,
)
object GoogleSheetsOptions {
  implicit val encoder: Encoder[GoogleSheetsOptions] = Encoder.instance { x =>
    Json.obj("range" := x.range, "skipLeadingRows" := x.skipLeadingRows)
  }
  implicit val decoder: Decoder[GoogleSheetsOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("range")
      v1 <- c.get[Option[Long]]("skipLeadingRows")
    } yield GoogleSheetsOptions(v0, v1)

  }
}
