package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class GlobalExplanation(
    // Class label for this set of global explanations. Will be empty/null for binary logistic and linear regression models. Sorted alphabetically in descending order.
    classLabel: Option[String] = None,
    // A list of the top global explanations. Sorted by absolute value of attribution in descending order.
    explanations: Option[List[Explanation]] = None,
)
object GlobalExplanation {
  implicit val encoder: Encoder[GlobalExplanation] = Encoder.instance { x =>
    Json.obj("classLabel" := x.classLabel, "explanations" := x.explanations)
  }
  implicit val decoder: Decoder[GlobalExplanation] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("classLabel")
      v1 <- c.get[Option[List[Explanation]]]("explanations")
    } yield GlobalExplanation(v0, v1)

  }
}
