package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class GetServiceAccountResponse( // The service account email address.
    email: Option[String] = None, // The resource type of the response.
    kind: Option[String] = None,
)
object GetServiceAccountResponse {
  implicit val encoder: Encoder[
    GetServiceAccountResponse
  ] = Encoder.instance(x => Json.obj("email" := x.email, "kind" := x.kind))
  implicit val decoder: Decoder[
    GetServiceAccountResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("email")
      v1 <- c.get[Option[String]]("kind")
    } yield GetServiceAccountResponse(v0, v1)
  }
}
