package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class GetQueryResultsResponse( // A hash of this response.
    etag: Option[String] = None, // The total number of bytes processed for this query.
    totalBytesProcessed: Option[Long] =
      None, // Whether the query result was fetched from the query cache.
    cacheHit: Option[Boolean] =
      None, // [Output-only] The first errors or warnings encountered during the running of the job. The final message includes the number of errors that caused the process to stop. Errors here do not necessarily mean that the job has completed or was unsuccessful.
    errors: Option[List[ErrorProto]] = None, // A token used for paging results.
    pageToken: Option[String] =
      None, // Whether the query has completed or not. If rows or totalRows are present, this will always be true. If this is false, totalRows will not be available.
    jobComplete: Option[Boolean] =
      None, // The schema of the results. Present only when the query completes successfully.
    schema: Option[TableSchema] =
      None, // [Output-only] The number of rows affected by a DML statement. Present only for DML statements INSERT, UPDATE or DELETE.
    numDmlAffectedRows: Option[Long] =
      None, // The total number of rows in the complete query result set, which can be more than the number of rows in this single page of results. Present only when the query completes successfully.
    totalRows: Option[BigInt] = None, // The resource type of the response.
    kind: Option[String] =
      None, // Reference to the BigQuery Job that was created to run the query. This field will be present even if the original request timed out, in which case GetQueryResults can be used to read the results once the query has completed. Since this API only returns the first page of results, subsequent pages can be fetched via the same mechanism (GetQueryResults).
    jobReference: Option[JobReference] =
      None, // An object with as many results as can be contained within the maximum permitted reply size. To get any additional rows, you can call GetQueryResults and specify the jobReference returned above. Present only when the query completes successfully.
    rows: Option[List[TableRow]] = None,
)
object GetQueryResultsResponse {
  implicit val encoder: Encoder[
    GetQueryResultsResponse
  ] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "totalBytesProcessed" := x.totalBytesProcessed,
      "cacheHit" := x.cacheHit,
      "errors" := x.errors,
      "pageToken" := x.pageToken,
      "jobComplete" := x.jobComplete,
      "schema" := x.schema,
      "numDmlAffectedRows" := x.numDmlAffectedRows,
      "totalRows" := x.totalRows,
      "kind" := x.kind,
      "jobReference" := x.jobReference,
      "rows" := x.rows,
    )
  }
  implicit val decoder: Decoder[
    GetQueryResultsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[Long]]("totalBytesProcessed")
      v2 <- c.get[Option[Boolean]]("cacheHit")
      v3 <- c.get[Option[List[ErrorProto]]]("errors")
      v4 <- c.get[Option[String]]("pageToken")
      v5 <- c.get[Option[Boolean]]("jobComplete")
      v6 <- c.get[Option[TableSchema]]("schema")
      v7 <- c.get[Option[Long]]("numDmlAffectedRows")
      v8 <- c.get[Option[BigInt]]("totalRows")
      v9 <- c.get[Option[String]]("kind")
      v10 <- c.get[Option[JobReference]]("jobReference")
      v11 <- c.get[Option[List[TableRow]]]("rows")
    } yield GetQueryResultsResponse(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11)
  }
}
