package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class GetIamPolicyRequest(
    // OPTIONAL: A `GetPolicyOptions` object for specifying options to `GetIamPolicy`.
    options: Option[GetPolicyOptions] = None
)
object GetIamPolicyRequest {
  implicit val encoder: Encoder[GetIamPolicyRequest] = Encoder.instance { x =>
    Json.obj("options" := x.options)
  }
  implicit val decoder: Decoder[GetIamPolicyRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[GetPolicyOptions]]("options")
    } yield GetIamPolicyRequest(v0)

  }
}
