package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class FeatureValue( // The categorical feature value.
    categoricalValue: Option[CategoricalValue] = None, // The feature column name.
    featureColumn: Option[String] =
      None, // The numerical feature value. This is the centroid value for this feature.
    numericalValue: Option[Double] = None,
)
object FeatureValue {
  implicit val encoder: Encoder[FeatureValue] = Encoder.instance { x =>
    Json.obj(
      "categoricalValue" := x.categoricalValue,
      "featureColumn" := x.featureColumn,
      "numericalValue" := x.numericalValue,
    )
  }
  implicit val decoder: Decoder[FeatureValue] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[CategoricalValue]]("categoricalValue")
      v1 <- c.get[Option[String]]("featureColumn")
      v2 <- c.get[Option[Double]]("numericalValue")
    } yield FeatureValue(v0, v1, v2)
  }
}
