package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ExternalDatasetReference(
    // [Required] The connection id that is used to access the external_source. Format: projects/{project_id}/locations/{location_id}/connections/{connection_id}
    connection: String, // [Required] External source that backs this dataset.
    externalSource: String,
)
object ExternalDatasetReference {
  implicit val encoder: Encoder[
    ExternalDatasetReference
  ] = Encoder.instance { x =>
    Json.obj("connection" := x.connection, "externalSource" := x.externalSource)
  }
  implicit val decoder: Decoder[
    ExternalDatasetReference
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("connection")
      v1 <- c.get[String]("externalSource")
    } yield ExternalDatasetReference(v0, v1)
  }
}
