package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ExternalDataConfiguration(
    // Additional properties to set if sourceFormat is set to Parquet.
    parquetOptions: Option[ParquetOptions] = None,
    // Additional properties to set if sourceFormat is set to CSV.
    csvOptions: Option[CsvOptions] = None,
    // ObjectMetadata is used to create Object Tables. Object Tables contain a listing of objects (with their metadata) found at the source_uris. If ObjectMetadata is set, source_format should be omitted. Currently SIMPLE is the only supported Object Metadata type.
    objectMetadata: Option[String] = None,
    // [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
    sourceFormat: String,
    // [Optional] The compression type of the data source. Possible values include GZIP and NONE. The default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
    compression: Option[String] = None,
    // [Optional] Provide a referencing file with the expected table schema. Enabled for the format: AVRO, PARQUET, ORC.
    referenceFileSchemaUri: Option[String] = None,
    // [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV, JSON, and Google Sheets. The default value is 0, which requires that all records are valid. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
    maxBadRecords: Option[Int] = None,
    // [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is ignored. Avro: This setting is ignored.
    ignoreUnknownValues: Option[Boolean] = None,
    // [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
    decimalTargetTypes: Option[List[String]] = None,
    // [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
    schema: Option[TableSchema] = None,
    // [Optional] Options to configure hive partitioning support.
    hivePartitioningOptions: Option[HivePartitioningOptions] = None,
    // Additional properties to set if sourceFormat is set to Avro.
    avroOptions: Option[AvroOptions] = None,
    // Additional properties to set if `sourceFormat` is set to `NEWLINE_DELIMITED_JSON`.
    jsonOptions: Option[JsonOptions] = None,
    // [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
    sourceUris: List[String],
    // [Optional, Trusted Tester] Connection for external data source.
    connectionId: Option[String] = None,
    // [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
    googleSheetsOptions: Option[GoogleSheetsOptions] = None,
    // [Optional] Specifies how source URIs are interpreted for constructing the file set to load. By default source URIs are expanded against the underlying storage. Other options include specifying manifest files. Only applicable to object storage systems.
    fileSetSpecType: Option[String] = None,
    // [Optional] Additional options if sourceFormat is set to BIGTABLE.
    bigtableOptions: Option[BigtableOptions] = None,
    // [Optional] Metadata Cache Mode for the table. Set this to enable caching of metadata from external data source.
    metadataCacheMode: Option[String] = None,
    // Try to detect schema and format options automatically. Any option specified explicitly will be honored.
    autodetect: Option[Boolean] = None,
)
object ExternalDataConfiguration {
  implicit val encoder: Encoder[
    ExternalDataConfiguration
  ] = Encoder.instance { x =>
    Json.obj(
      "parquetOptions" := x.parquetOptions,
      "csvOptions" := x.csvOptions,
      "objectMetadata" := x.objectMetadata,
      "sourceFormat" := x.sourceFormat,
      "compression" := x.compression,
      "referenceFileSchemaUri" := x.referenceFileSchemaUri,
      "maxBadRecords" := x.maxBadRecords,
      "ignoreUnknownValues" := x.ignoreUnknownValues,
      "decimalTargetTypes" := x.decimalTargetTypes,
      "schema" := x.schema,
      "hivePartitioningOptions" := x.hivePartitioningOptions,
      "avroOptions" := x.avroOptions,
      "jsonOptions" :=
        x.jsonOptions,
      "sourceUris" := x.sourceUris,
      "connectionId" := x.connectionId,
      "googleSheetsOptions" := x.googleSheetsOptions,
      "fileSetSpecType" := x.fileSetSpecType,
      "bigtableOptions" := x.bigtableOptions,
      "metadataCacheMode" := x.metadataCacheMode,
      "autodetect"
        := x.autodetect,
    )
  }
  implicit val decoder: Decoder[
    ExternalDataConfiguration
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ParquetOptions]]("parquetOptions")
      v1 <- c.get[Option[CsvOptions]]("csvOptions")
      v2 <- c.get[Option[String]]("objectMetadata")
      v3 <- c.get[String]("sourceFormat")
      v4 <- c.get[Option[String]]("compression")
      v5 <- c.get[Option[String]]("referenceFileSchemaUri")
      v6 <- c.get[Option[Int]]("maxBadRecords")
      v7 <- c.get[Option[Boolean]]("ignoreUnknownValues")
      v8 <- c.get[Option[List[String]]]("decimalTargetTypes")
      v9 <- c.get[Option[TableSchema]]("schema")
      v10 <- c.get[Option[HivePartitioningOptions]]("hivePartitioningOptions")
      v11 <- c.get[Option[AvroOptions]]("avroOptions")
      v12 <- c.get[Option[JsonOptions]]("jsonOptions")
      v13 <- c.get[List[String]]("sourceUris")
      v14 <- c.get[Option[String]]("connectionId")
      v15 <- c.get[Option[GoogleSheetsOptions]]("googleSheetsOptions")
      v16 <- c.get[Option[String]]("fileSetSpecType")
      v17 <- c.get[Option[BigtableOptions]]("bigtableOptions")
      v18 <- c.get[Option[String]]("metadataCacheMode")
      v19 <- c.get[Option[Boolean]]("autodetect")
    } yield ExternalDataConfiguration(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
    )
  }
}
