package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Expr(
    // Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    description: Option[String] = None,
    // Textual representation of an expression in Common Expression Language syntax.
    expression: Option[String] = None,
    // Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    location: Option[String] = None,
    // Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    title: Option[String] = None,
)
object Expr {
  implicit val encoder: Encoder[Expr] = Encoder.instance { x =>
    Json.obj(
      "description" := x.description,
      "expression" := x.expression,
      "location"
        := x.location,
      "title" := x.title,
    )
  }
  implicit val decoder: Decoder[Expr] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("description")
      v1 <- c.get[Option[String]]("expression")
      v2 <- c.get[Option[String]]("location")
      v3 <- c.get[Option[String]]("title")
    } yield Expr(v0, v1, v2, v3)
  }
}
