package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Explanation( // Attribution of feature.
    attribution: Option[Double] =
      None, // The full feature name. For non-numerical features, will be formatted like `.`. Overall size of feature name will always be truncated to first 120 characters.
    featureName: Option[String] = None,
)
object Explanation {
  implicit val encoder: Encoder[Explanation] = Encoder.instance { x =>
    Json.obj("attribution" := x.attribution, "featureName" := x.featureName)
  }
  implicit val decoder: Decoder[Explanation] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("attribution")
      v1 <- c.get[Option[String]]("featureName")
    } yield Explanation(v0, v1)
  }
}
