package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ExplainQueryStep( // Machine-readable operation type.
    kind: Option[String] = None, // Human-readable stage descriptions.
    substeps: Option[List[String]] = None,
)
object ExplainQueryStep {
  implicit val encoder: Encoder[ExplainQueryStep] = Encoder.instance { x =>
    Json.obj("kind" := x.kind, "substeps" := x.substeps)
  }
  implicit val decoder: Decoder[ExplainQueryStep] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("kind")
      v1 <- c.get[Option[List[String]]]("substeps")
    } yield ExplainQueryStep(v0, v1)
  }
}
