package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class ExplainQueryStage(
    // Number of parallel input segments to be processed.
    parallelInputs: Option[Long] = None, // Human-readable name for stage.
    name: Option[String] = None,
    // Milliseconds the slowest shard spent waiting to be scheduled.
    waitMsMax: Option[Long] = None,
    // Milliseconds the average shard spent reading input.
    readMsAvg: Option[Long] = None,
    // Number of parallel input segments completed.
    completedParallelInputs: Option[Long] = None,
    // Number of records written by the stage.
    recordsWritten: Option[Long] = None,
    // Relative amount of time the slowest shard spent on CPU-bound tasks.
    computeRatioMax: Option[Double] = None,
    // Milliseconds the average shard spent waiting to be scheduled.
    waitMsAvg: Option[Long] = None, // Number of records read into the stage.
    recordsRead: Option[Long] = None,
    // Milliseconds the average shard spent on writing output.
    writeMsAvg: Option[Long] = None,
    // Stage start time represented as milliseconds since epoch.
    startMs: Option[FiniteDuration] = None,
    // Slot-milliseconds used by the stage.
    slotMs: Option[FiniteDuration] = None,
    // Relative amount of time the average shard spent reading input.
    readRatioAvg: Option[Double] = None,
    // Milliseconds the slowest shard spent on CPU-bound tasks.
    computeMsMax: Option[Long] = None, // Unique ID for stage within plan.
    id: Option[Long] = None,
    // Relative amount of time the slowest shard spent waiting to be scheduled.
    waitRatioMax: Option[Double] = None,
    // Relative amount of time the average shard spent waiting to be scheduled.
    waitRatioAvg: Option[Double] = None,
    // Relative amount of time the slowest shard spent on writing output.
    writeRatioMax: Option[Double] = None, // Current status for the stage.
    status: Option[String] = None,
    // Total number of bytes written to shuffle and spilled to disk.
    shuffleOutputBytesSpilled: Option[Long] = None,
    // Milliseconds the average shard spent on CPU-bound tasks.
    computeMsAvg: Option[Long] = None,
    // Relative amount of time the average shard spent on CPU-bound tasks.
    computeRatioAvg: Option[Double] = None,
    // List of operations within the stage in dependency order (approximately chronological).
    steps: Option[List[ExplainQueryStep]] = None,
    // Stage end time represented as milliseconds since epoch.
    endMs: Option[FiniteDuration] = None,
    // Milliseconds the slowest shard spent reading input.
    readMsMax: Option[Long] = None,
    // Relative amount of time the slowest shard spent reading input.
    readRatioMax: Option[Double] = None,
    // Milliseconds the slowest shard spent on writing output.
    writeMsMax: Option[Long] = None,
    // Relative amount of time the average shard spent on writing output.
    writeRatioAvg: Option[Double] = None,
    // Total number of bytes written to shuffle.
    shuffleOutputBytes: Option[Long] = None,
    // IDs for stages that are inputs to this stage.
    inputStages: Option[List[Long]] = None,
)
object ExplainQueryStage {
  implicit val encoder: Encoder[ExplainQueryStage] = Encoder.instance { x =>
    Json.obj(
      "parallelInputs" := x.parallelInputs,
      "name" := x.name,
      "waitMsMax" := x.waitMsMax,
      "readMsAvg" := x.readMsAvg,
      "completedParallelInputs" := x.completedParallelInputs,
      "recordsWritten" := x.recordsWritten,
      "computeRatioMax" := x.computeRatioMax,
      "waitMsAvg" := x.waitMsAvg,
      "recordsRead" := x.recordsRead,
      "writeMsAvg" := x.writeMsAvg,
      "startMs" :=
        x.startMs,
      "slotMs" := x.slotMs,
      "readRatioAvg" := x.readRatioAvg,
      "computeMsMax" := x.computeMsMax,
      "id" := x.id,
      "waitRatioMax" := x.waitRatioMax,
      "waitRatioAvg" := x.waitRatioAvg,
      "writeRatioMax" := x.writeRatioMax,
      "status" := x.status,
      "shuffleOutputBytesSpilled" := x.shuffleOutputBytesSpilled,
      "computeMsAvg" := x.computeMsAvg,
      "computeRatioAvg" := x.computeRatioAvg,
      "steps" := x.steps,
      "endMs" := x.endMs,
      "readMsMax" := x.readMsMax,
      "readRatioMax" := x.readRatioMax,
      "writeMsMax" := x.writeMsMax,
      "writeRatioAvg" := x.writeRatioAvg,
      "shuffleOutputBytes" := x.shuffleOutputBytes,
      "inputStages" := x.inputStages,
    )
  }
  implicit val decoder: Decoder[ExplainQueryStage] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("parallelInputs")
      v1 <- c.get[Option[String]]("name")
      v2 <- c.get[Option[Long]]("waitMsMax")
      v3 <- c.get[Option[Long]]("readMsAvg")
      v4 <- c.get[Option[Long]]("completedParallelInputs")
      v5 <- c.get[Option[Long]]("recordsWritten")
      v6 <- c.get[Option[Double]]("computeRatioMax")
      v7 <- c.get[Option[Long]]("waitMsAvg")
      v8 <- c.get[Option[Long]]("recordsRead")
      v9 <- c.get[Option[Long]]("writeMsAvg")
      v10 <- c.get[Option[FiniteDuration]]("startMs")
      v11 <- c.get[Option[FiniteDuration]]("slotMs")
      v12 <- c.get[Option[Double]]("readRatioAvg")
      v13 <- c.get[Option[Long]]("computeMsMax")
      v14 <- c.get[Option[Long]]("id")
      v15 <- c.get[Option[Double]]("waitRatioMax")
      v16 <- c.get[Option[Double]]("waitRatioAvg")
      v17 <- c.get[Option[Double]]("writeRatioMax")
      v18 <- c.get[Option[String]]("status")
      v19 <- c.get[Option[Long]]("shuffleOutputBytesSpilled")
      v20 <- c.get[Option[Long]]("computeMsAvg")
      v21 <- c.get[Option[Double]]("computeRatioAvg")
      v22 <- c.get[Option[List[ExplainQueryStep]]]("steps")
      v23 <- c.get[Option[FiniteDuration]]("endMs")
      v24 <- c.get[Option[Long]]("readMsMax")
      v25 <- c.get[Option[Double]]("readRatioMax")
      v26 <- c.get[Option[Long]]("writeMsMax")
      v27 <- c.get[Option[Double]]("writeRatioAvg")
      v28 <- c.get[Option[Long]]("shuffleOutputBytes")
      v29 <- c.get[Option[List[Long]]]("inputStages")
    } yield ExplainQueryStage(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
      v23,
      v24,
      v25,
      v26,
      v27,
      v28,
      v29,
    )

  }
}
