package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class EvaluationMetrics( // Populated for ARIMA models.
    arimaForecastingMetrics: Option[ArimaForecastingMetrics] =
      None, // Populated for implicit feedback type matrix factorization models.
    rankingMetrics: Option[RankingMetrics] =
      None, // Populated for multi-class classification/classifier models.
    multiClassClassificationMetrics: Option[MultiClassClassificationMetrics] =
      None, // Populated for binary classification/classifier models.
    binaryClassificationMetrics: Option[BinaryClassificationMetrics] =
      None, // Populated for regression models and explicit feedback type matrix factorization models.
    regressionMetrics: Option[RegressionMetrics] = None, // Populated for clustering models.
    clusteringMetrics: Option[ClusteringMetrics] =
      None, // Evaluation metrics when the model is a dimensionality reduction model, which currently includes PCA.
    dimensionalityReductionMetrics: Option[DimensionalityReductionMetrics] = None,
)
object EvaluationMetrics {
  implicit val encoder: Encoder[EvaluationMetrics] = Encoder.instance { x =>
    Json.obj(
      "arimaForecastingMetrics" := x.arimaForecastingMetrics,
      "rankingMetrics"
        := x.rankingMetrics,
      "multiClassClassificationMetrics" := x.multiClassClassificationMetrics,
      "binaryClassificationMetrics" := x.binaryClassificationMetrics,
      "regressionMetrics" := x.regressionMetrics,
      "clusteringMetrics" := x.clusteringMetrics,
      "dimensionalityReductionMetrics" := x.dimensionalityReductionMetrics,
    )
  }
  implicit val decoder: Decoder[EvaluationMetrics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ArimaForecastingMetrics]]("arimaForecastingMetrics")
      v1 <- c.get[Option[RankingMetrics]]("rankingMetrics")
      v2 <- c.get[Option[MultiClassClassificationMetrics]]("multiClassClassificationMetrics")
      v3 <- c.get[Option[BinaryClassificationMetrics]]("binaryClassificationMetrics")
      v4 <- c.get[Option[RegressionMetrics]]("regressionMetrics")
      v5 <- c.get[Option[ClusteringMetrics]]("clusteringMetrics")
      v6 <- c.get[Option[DimensionalityReductionMetrics]]("dimensionalityReductionMetrics")
    } yield EvaluationMetrics(v0, v1, v2, v3, v4, v5, v6)

  }
}
