package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ErrorProto(
    // Debugging information. This property is internal to Google and should not be used.
    debugInfo: Option[String] = None,
    // Specifies where the error occurred, if present.
    location: Option[String] = None, // A human-readable description of the error.
    message: Option[String] = None,
    // A short error code that summarizes the error.
    reason: Option[String] = None,
)
object ErrorProto {
  implicit val encoder: Encoder[ErrorProto] = Encoder.instance { x =>
    Json.obj(
      "debugInfo" := x.debugInfo,
      "location" := x.location,
      "message" := x.message,
      "reason" := x.reason,
    )
  }
  implicit val decoder: Decoder[ErrorProto] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("debugInfo")
      v1 <- c.get[Option[String]]("location")
      v2 <- c.get[Option[String]]("message")
      v3 <- c.get[Option[String]]("reason")
    } yield ErrorProto(v0, v1, v2, v3)
  }
}
