package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Entry( // Number of items being predicted as this label.
    itemCount: Option[Long] =
      None, // The predicted label. For confidence_threshold > 0, we will also add an entry indicating the number of items under the confidence threshold.
    predictedLabel: Option[String] = None,
)
object Entry {
  implicit val encoder: Encoder[Entry] = Encoder.instance { x =>
    Json.obj("itemCount" := x.itemCount, "predictedLabel" := x.predictedLabel)
  }
  implicit val decoder: Decoder[Entry] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("itemCount")
      v1 <- c.get[Option[String]]("predictedLabel")
    } yield Entry(v0, v1)
  }
}
