package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class EncryptionConfiguration(
    // Optional. Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
    kmsKeyName: Option[String] = None
)
object EncryptionConfiguration {
  implicit val encoder: Encoder[
    EncryptionConfiguration
  ] = Encoder.instance(x => Json.obj("kmsKeyName" := x.kmsKeyName))
  implicit val decoder: Decoder[
    EncryptionConfiguration
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("kmsKeyName")
    } yield EncryptionConfiguration(v0)
  }
}
