package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DoubleRange( // Max value of the double parameter.
    max: Option[Double] = None, // Min value of the double parameter.
    min: Option[Double] = None,
)
object DoubleRange {
  implicit val encoder: Encoder[DoubleRange] = Encoder.instance { x =>
    Json.obj("max" := x.max, "min" := x.min)
  }
  implicit val decoder: Decoder[DoubleRange] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("max")
      v1 <- c.get[Option[Double]]("min")
    } yield DoubleRange(v0, v1)
  }
}
