package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DoubleHparamSearchSpace(
    // Candidates of the double hyperparameter.
    candidates: Option[DoubleCandidates] = None,
    // Range of the double hyperparameter.
    range: Option[DoubleRange] = None,
)
object DoubleHparamSearchSpace {
  implicit val encoder: Encoder[
    DoubleHparamSearchSpace
  ] = Encoder.instance { x =>
    Json.obj("candidates" := x.candidates, "range" := x.range)
  }
  implicit val decoder: Decoder[
    DoubleHparamSearchSpace
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[DoubleCandidates]]("candidates")
      v1 <- c.get[Option[DoubleRange]]("range")
    } yield DoubleHparamSearchSpace(v0, v1)
  }
}
