package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DoubleCandidates(
    // Candidates for the double parameter in increasing order.
    candidates: Option[List[Double]] = None
)
object DoubleCandidates {
  implicit val encoder: Encoder[DoubleCandidates] = Encoder.instance { x =>
    Json.obj("candidates" := x.candidates)
  }
  implicit val decoder: Decoder[DoubleCandidates] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Double]]]("candidates")
    } yield DoubleCandidates(v0)
  }
}
