package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DmlStatistics(
    // Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
    deletedRowCount: Option[Long] = None,
    // Number of inserted Rows. Populated by DML INSERT and MERGE statements.
    insertedRowCount: Option[Long] = None,
    // Number of updated Rows. Populated by DML UPDATE and MERGE statements.
    updatedRowCount: Option[Long] = None,
)
object DmlStatistics {
  implicit val encoder: Encoder[DmlStatistics] = Encoder.instance { x =>
    Json.obj(
      "deletedRowCount" := x.deletedRowCount,
      "insertedRowCount" := x.insertedRowCount,
      "updatedRowCount" := x.updatedRowCount,
    )
  }
  implicit val decoder: Decoder[DmlStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("deletedRowCount")
      v1 <- c.get[Option[Long]]("insertedRowCount")
      v2 <- c.get[Option[Long]]("updatedRowCount")
    } yield DmlStatistics(v0, v1, v2)
  }
}
