package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DimensionalityReductionMetrics(
    // Total percentage of variance explained by the selected principal components.
    totalExplainedVarianceRatio: Option[Double] = None
)
object DimensionalityReductionMetrics {
  implicit val encoder: Encoder[
    DimensionalityReductionMetrics
  ] = Encoder.instance { x =>
    Json.obj("totalExplainedVarianceRatio" := x.totalExplainedVarianceRatio)
  }
  implicit val decoder: Decoder[
    DimensionalityReductionMetrics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("totalExplainedVarianceRatio")
    } yield DimensionalityReductionMetrics(v0)
  }
}
