package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DestinationTableProperties(
    // [Optional] The description for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current description is provided, the job will fail.
    description: Option[String] = None,
    // [Internal] This field is for Google internal use only.
    expirationTime: Option[String] = None,
    // [Optional] The friendly name for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current friendly name is provided, the job will fail.
    friendlyName: Option[String] = None,
    // [Optional] The labels associated with this table. You can use these to organize and group your tables. This will only be used if the destination table is newly created. If the table already exists and labels are different than the current labels are provided, the job will fail.
    labels: Option[Map[String, String]] = None,
)
object DestinationTableProperties {
  implicit val encoder: Encoder[
    DestinationTableProperties
  ] = Encoder.instance { x =>
    Json.obj(
      "description" := x.description,
      "expirationTime" := x.expirationTime,
      "friendlyName" := x.friendlyName,
      "labels" := x.labels,
    )
  }
  implicit val decoder: Decoder[
    DestinationTableProperties
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("description")
      v1 <- c.get[Option[String]]("expirationTime")
      v2 <- c.get[Option[String]]("friendlyName")
      v3 <- c.get[Option[Map[String, String]]]("labels")
    } yield DestinationTableProperties(v0, v1, v2, v3)
  }
}
