package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetTag(
    // [Required] The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is org id.
    tagKey: String,
    // [Required] Friendly short name of the tag value, e.g. "production".
    tagValue: String,
)
object DatasetTag {
  implicit val encoder: Encoder[DatasetTag] = Encoder.instance { x =>
    Json.obj("tagKey" := x.tagKey, "tagValue" := x.tagValue)
  }
  implicit val decoder: Decoder[DatasetTag] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("tagKey")
      v1 <- c.get[String]("tagValue")
    } yield DatasetTag(v0, v1)
  }
}
