package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetReference(
    // [Required] A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
    datasetId: String,
    // [Optional] The ID of the project containing this dataset.
    projectId: Option[String] = None,
)
object DatasetReference {
  implicit val encoder: Encoder[DatasetReference] = Encoder.instance { x =>
    Json.obj("datasetId" := x.datasetId, "projectId" := x.projectId)
  }
  implicit val decoder: Decoder[DatasetReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("datasetId")
      v1 <- c.get[Option[String]]("projectId")
    } yield DatasetReference(v0, v1)
  }
}
