package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetListDataset(
    // The dataset reference. Use this property to access specific parts of the dataset's ID, such as project ID or dataset ID.
    datasetReference: Option[DatasetReference] = None,
    // The geographic location where the data resides.
    location: Option[String] = None,
    // A descriptive name for the dataset, if one exists.
    friendlyName: Option[String] = None,
    // The fully-qualified, unique, opaque ID of the dataset.
    id: Option[String] = None,
    // The labels associated with this dataset. You can use these to organize and group your datasets.
    labels: Option[Map[String, String]] = None,
    // The resource type. This property always returns the value "bigquery#dataset".
    kind: Option[String] = None,
)
object DatasetListDataset {
  implicit val encoder: Encoder[DatasetListDataset] = Encoder.instance { x =>
    Json.obj(
      "datasetReference" := x.datasetReference,
      "location" := x.location,
      "friendlyName" := x.friendlyName,
      "id" := x.id,
      "labels" := x.labels,
      "kind" := x.kind,
    )
  }
  implicit val decoder: Decoder[DatasetListDataset] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[DatasetReference]]("datasetReference")
      v1 <- c.get[Option[String]]("location")
      v2 <- c.get[Option[String]]("friendlyName")
      v3 <- c.get[Option[String]]("id")
      v4 <- c.get[Option[Map[String, String]]]("labels")
      v5 <- c.get[Option[String]]("kind")
    } yield DatasetListDataset(v0, v1, v2, v3, v4, v5)

  }
}
