package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetList(
    // An array of the dataset resources in the project. Each resource contains basic information. For full information about a particular dataset resource, use the Datasets: get method. This property is omitted when there are no datasets in the project.
    datasets: Option[List[DatasetListDataset]] = None,
    // A hash value of the results page. You can use this property to determine if the page has changed since the last request.
    etag: Option[String] = None,
    // The list type. This property always returns the value "bigquery#datasetList".
    kind: Option[String] = None,
    // A token that can be used to request the next results page. This property is omitted on the final results page.
    nextPageToken: Option[String] = None,
)
object DatasetList {
  implicit val encoder: Encoder[DatasetList] = Encoder.instance { x =>
    Json.obj(
      "datasets" := x.datasets,
      "etag" := x.etag,
      "kind" := x.kind,
      "nextPageToken" := x.nextPageToken,
    )
  }
  implicit val decoder: Decoder[DatasetList] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[DatasetListDataset]]]("datasets")
      v1 <- c.get[Option[String]]("etag")
      v2 <- c.get[Option[String]]("kind")
      v3 <- c.get[Option[String]]("nextPageToken")
    } yield DatasetList(v0, v1, v2, v3)
  }
}
